# First we read the testset.
n = int(input())

# Next, we convert the testset to matrices.
A = []
T = []
for i in range(2*n):
    data = input()
    line = data.rstrip('\n')
    row = line.split(' ')
    row = [ int(row[k]) for k in range(n) ]
    if i < n:
        A.append(row)
    else:
        T.append(row)


# Get all the upperdiagonal, lowerdiagonal and diagonal numbers of the matrix.
def get_elements(matrix):
    size = len(matrix)
    upper_diagonal = [ matrix[i][i+1] for i in range(size-1) ]
    diagonal = [ matrix[i][i] for i in range(size) ]
    lower_diagonal = [ matrix[i][i-1] for i in range(1,size) ]
    
    return upper_diagonal, diagonal, lower_diagonal


# Solve the determinant problem in a recursive way.
def recursion(matrix):
    size = len(matrix)
    upper_diagonal, diagonal, lower_diagonal = get_elements(matrix)
    
    f0 = 1
    f1 = diagonal[0]
    
    for i in range(1,size):
        ftemp = int(f1)
        f1 = int(diagonal[i])*int(f1) - int(upper_diagonal[i-1])*int(lower_diagonal[i-1])*int(f0)
        f0 = int(ftemp)
    
    return f1

# Finally, we print the answer of the testset.
answer = abs(recursion(T))
print(answer)
